/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.launching;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.ui.launching.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;
import org2.eclipse.php.internal.ui.util.SWTFactory;

public class LaunchConfigurationsSelectionDialog
extends SelectionDialog {
    private static final int Y = 300;
    private static final int X = 400;
    private boolean fShowSelectButtons = false;
    protected StructuredViewer fViewer = null;
    private final List<ILaunchConfiguration> configurations;

    public LaunchConfigurationsSelectionDialog(Shell parentShell, List<ILaunchConfiguration> configurations) {
        super(parentShell);
        this.configurations = configurations;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setShowSelectAllButtons(true);
        this.setMessage(Messages.LaunchConfigurationsSelectionDialog_confirmUpdateMessage);
        this.setTitle(Messages.LaunchConfigurationsSelectionDialog_confirmUpdateTitle);
        this.setHelpAvailable(false);
    }

    protected void initializeControls() {
        this.getCheckBoxTableViewer().setAllChecked(true);
        this.getButton(0).setEnabled(this.isValid());
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        this.initializeControls();
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        String label = this.getMessage();
        if (!StringUtil.isEmpty((String)label)) {
            SWTFactory.createWrapLabel((Composite)comp, (String)label, (int)1);
        }
        if (!StringUtil.isEmpty((String)(label = this.getViewerLabel()))) {
            SWTFactory.createLabel((Composite)comp, (String)label, (int)1);
        }
        this.fViewer = this.createViewer(comp);
        this.fViewer.setLabelProvider(this.getLabelProvider());
        this.fViewer.setContentProvider(this.getContentProvider());
        this.fViewer.setInput(this.getViewerInput());
        List selectedElements = this.getInitialElementSelections();
        if (!CollectionsUtil.isEmpty((Collection)selectedElements)) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        }
        this.addViewerListeners(this.fViewer);
        this.addCustomFooterControls(comp);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected Object getViewerInput() {
        return this.configurations;
    }

    protected String getViewerLabel() {
        return null;
    }

    protected CheckboxTableViewer getCheckBoxTableViewer() {
        return (CheckboxTableViewer)this.fViewer;
    }

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DefaultLabelProvider();
    }

    protected StructuredViewer createViewer(Composite parent) {
        Table table = new Table(parent, 2084);
        table.setLayoutData((Object)new GridData(1808));
        return new CheckboxTableViewer(table);
    }

    protected void addViewerListeners(StructuredViewer viewer) {
        this.getCheckBoxTableViewer().addCheckStateListener((ICheckStateListener)new DefaultCheckboxListener());
    }

    protected boolean isValid() {
        return this.getCheckBoxTableViewer().getCheckedElements().length > 0;
    }

    protected void okPressed() {
        Object[] elements = this.getCheckBoxTableViewer().getCheckedElements();
        this.setResult(Arrays.asList(elements));
        super.okPressed();
    }

    protected void addCustomFooterControls(Composite parent) {
        if (this.fShowSelectButtons) {
            Composite comp = SWTFactory.createComposite((Composite)parent, (int)2, (int)1, (int)768);
            GridData gd = (GridData)comp.getLayoutData();
            gd.horizontalAlignment = 0x1000008;
            Button button = SWTFactory.createPushButton((Composite)comp, (String)Messages.LaunchConfigurationsSelectionDialog_selectAll, null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LaunchConfigurationsSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(true);
                    LaunchConfigurationsSelectionDialog.this.getButton(0).setEnabled(LaunchConfigurationsSelectionDialog.this.isValid());
                }
            });
            button = SWTFactory.createPushButton((Composite)comp, (String)Messages.LaunchConfigurationsSelectionDialog_deselectAll, null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LaunchConfigurationsSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(false);
                    LaunchConfigurationsSelectionDialog.this.getButton(0).setEnabled(LaunchConfigurationsSelectionDialog.this.isValid());
                }
            });
        }
    }

    protected void setShowSelectAllButtons(boolean setting) {
        this.fShowSelectButtons = setting;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(400, 300);
            }
        }
        return new Point(400, 300);
    }

    private class DefaultCheckboxListener
    implements ICheckStateListener {
        private DefaultCheckboxListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            LaunchConfigurationsSelectionDialog.this.getButton(0).setEnabled(LaunchConfigurationsSelectionDialog.this.isValid());
        }
    }
}

